package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadPricesIndicationJson.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/LoadPricesIndicationJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.common.ProductPrices;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadPricesIndicationJson extends AbstractJsonAction {

    private static final long serialVersionUID = -1437968191353986009L;

    protected transient PricesService pricesService;

    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    /* Incomming parameters */
    protected String filter;
    protected String campaigns;
    protected String excludeDomainId;
    protected String excludeZoneId;
    protected String excludePracticedSystemId;

    /* Outgoing parameters */
    protected ProductPrices prices;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public void setExcludeDomainId(String excludeDomainId) {
        this.excludeDomainId = excludeDomainId;
    }

    public void setExcludeZoneId(String excludeZoneId) {
        this.excludeZoneId = excludeZoneId;
    }

    public void setExcludePracticedSystemId(String excludePracticedSystemId) {
        this.excludePracticedSystemId = excludePracticedSystemId;
    }

    @Override
    public String execute() throws Exception {
        Price priceFilter = getGson().fromJson(filter, Price.class);
        prices = pricesService.computePricesIndication(priceFilter, campaigns, excludeDomainId, excludeZoneId, excludePracticedSystemId);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return prices;
    }

}
