package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AttachmentsUploadJson.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/AttachmentsUploadJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;
import java.util.List;

import com.google.common.collect.Lists;

import fr.inra.agrosyst.api.entities.AttachmentMetadata;
import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class AttachmentsUploadJson extends AbstractJsonAction {

    private static final long serialVersionUID = 885536225788377317L;

    protected transient AttachmentService attachmentService;

    protected String objectReferenceId;

    protected List<File> files;
    protected List<String> filesContentType;
    protected List<String> filesFileName;

    protected List<AttachmentMetadata> attachmentMetadatas;

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public void setObjectReferenceId(String objectReferenceId) {
        this.objectReferenceId = objectReferenceId;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setFilesContentType(List<String> filesContentType) {
        this.filesContentType = filesContentType;
    }

    public void setFilesFileName(List<String> filesFileName) {
        this.filesFileName = filesFileName;
    }

    @Override
    public String execute() throws Exception {
        attachmentMetadatas = Lists.newArrayList();
        for (int i = 0; i < files.size(); i++) {
            File file = files.get(i);
            String fileFileName = filesFileName.get(i);
            String fileContentType = filesContentType.get(i);
            AttachmentMetadata attachmentMetadata = attachmentService.addAttachment(objectReferenceId,
                    new FileInputStream(file), fileFileName, fileContentType);
            attachmentMetadatas.add(attachmentMetadata);
        }
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return attachmentMetadatas;
    }
}
