package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersList.java 3775 2014-03-17 21:30:14Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserFilter;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;

/**
 * User list action.
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class UsersList extends AbstractAdminAction {

    private static final long serialVersionUID = -4895779258937582288L;

    protected transient UserService userService;

    protected UserFilter usersFilter;

    protected boolean importUsersAndRolesFileError;

    public void setImportUsersAndRolesFileError(boolean importUsersAndRolesFileError) {
        this.importUsersAndRolesFileError = importUsersAndRolesFileError;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    /**
     * User result list serialized as JSON.
     */
    protected ResultList<UserDto> users;

    @Override
    public String execute() throws Exception {
        if (importUsersAndRolesFileError) {
            notificationSupport.usersAndRolesImportFailed("format de fichier incorrect");
            importUsersAndRolesFileError = false;
        }
        checkIsAdmin();
        usersFilter = new UserFilter();
        usersFilter.setActive(true);
        usersFilter.setPageSize(getConfig().getListResultsPerPage());
        users = userService.getFilteredUsers(usersFilter, true);
        return SUCCESS;
    }

    public ResultList<UserDto> getUsers() {
        return users;
    }

    public Map<RoleType, String> getRoleTypes() {
        return getEnumAsMap(RoleType.values());
    }

    public UserFilter getUsersFilter() {
        return usersFilter;
    }

}
