package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersAndRolesImport.java 3769 2014-03-17 14:22:08Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersAndRolesImport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;

/**
 * Import d'utilisateur par lot.
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 */
@Results({
        @Result(type = "redirectAction", name = "input", params = {"namespace", "/security", "actionName", "users-list", "importUsersAndRolesFileError", "true"})
})
public class UsersAndRolesImport extends AbstractAdminAction {

    private static final Log log = LogFactory.getLog(UsersAndRolesImport.class);

    private static final long serialVersionUID = 5338924873719324729L;

    protected transient UserService userService;

    protected File userFile;

    protected File rolesFile;

    public void setRolesFile(File rolesFile) {
        this.rolesFile = rolesFile;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }


    public void setUserFile(File userFile) {
        this.userFile = userFile;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"namespace", "/security", "actionName", "users-list"}),
            @Result(name = ERROR, type = "redirectAction", params = {"namespace", "/security", "actionName", "users-list"})
    })
    public String execute() throws Exception {
        boolean errors = false;
        if (userFile != null) {
            checkIsAdmin();
            try {
                ImportResult result = userService.importUsers(new FileInputStream(userFile));
                notificationSupport.userImported(result);
            } catch (Exception ex) {
                errors = true;
                notificationSupport.usersImportFailed(ex.getMessage());
                if (log.isErrorEnabled()) {
                    log.error("Can't import user file", ex);
                }
            }
        }
        if (rolesFile != null) {
            checkIsAdmin();
            try {
                ImportResult result = authorizationService.importRoles(new FileInputStream(rolesFile));
                notificationSupport.userRolesUpdated(result);
            } catch (Exception ex) {
                errors = true;
                notificationSupport.rulesImportFailed(ex.getMessage());
                if (log.isErrorEnabled()) {
                    log.error("Can't import roles file", ex);
                }
            }
        }
        if (errors) {
            return ERROR;
        } else {
            return SUCCESS;
        }
    }

}
