package fr.inra.agrosyst.web.actions.publishedmessage;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: InfoMessageList.java 4440 2014-10-16 17:25:26Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/publishedmessage/InfoMessageList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.history.MessageFilter;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;

/**
 * Created by davidcosse on 14/10/14.
 */
public class InfoMessageList extends AbstractAdminAction {

    private static final long serialVersionUID = 1L;

    protected MessageFilter messageFilter;

    protected ResultList<Message> messages;

    @Override
    public String execute() throws Exception {

        messageFilter = new MessageFilter();
        messageFilter.setPageSize(getConfig().getListResultsPerPage());
        messages = messageService.getFilteredMessages(messageFilter);
        return SUCCESS;
    }

    public ResultList<Message> getMessages() {
        return messages;
    }

    public MessageFilter getMessageFilter() {
        return messageFilter;
    }
}
