package fr.inra.agrosyst.web.actions.publishedmessage;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: InfoMessageEdit.java 4444 2014-10-17 13:06:36Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/publishedmessage/InfoMessageEdit.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

/**
 * Created by davidcosse on 14/10/14.
 */
public class InfoMessageEdit extends AbstractAdminAction {

    private static final long serialVersionUID = 1L;

    protected String title;

    protected String content;

    @Override
    @Action("info-message-edit-input")
    public String input() throws Exception {
        return super.input();
    }

    @Override
    public void validate() {
        if (StringUtils.isBlank(title)){
            addActionError("Le titre est obligatoire");
        }
    }

    @Override
    @Action(results = {
            @Result(type = "redirectAction", params = {"actionName", "info-message-list"})})
    public String execute() throws Exception {
        checkIsAdmin();

        if (!Strings.isNullOrEmpty(title)) {
            messageService.publishMessage(title, content);
        }

        //notificationSupport.userSaved(user);

        return SUCCESS;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTitle() {
        return title;
    }

    public String getContent() {
        return content;
    }
}
