package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedPlotsList.java 3531 2014-02-27 15:54:43Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedPlotsList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class PracticedPlotsList extends AbstractAgrosystAction {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 3084229660685255829L;

    protected transient PracticedPlotService practicedPlotService;

    public void setPracticedPlotService(PracticedPlotService practicedPlotService) {
        this.practicedPlotService = practicedPlotService;
    }

    /**
     * Initial list data.
     */
    protected ResultList<PracticedPlotDto> practicedPlots;

    @Override
    public String execute() throws Exception {

        NavigationContext navigationContext = getNavigationContext();
        PracticedPlotFilter filter = new PracticedPlotFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(getConfig().getListResultsPerPage());

        practicedPlots = practicedPlotService.getFilteredPracticedPlotsDto(filter);
        return SUCCESS;
    }

    public ResultList<PracticedPlotDto> getPracticedPlots() {
        return practicedPlots;
    }
}
