package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadToolsCouplingJson.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadToolsCouplingJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.services.domain.ToolsCouplingDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadToolsCouplingJson  extends AbstractJsonAction {

    private static final long serialVersionUID = -6352586060492623909L;

    protected transient EffectiveCropCycleService effectiveService;
    protected transient PracticedSystemService practicedSystemService;

    protected AgrosystInterventionType agrosystInterventionType;

    protected String growingSystemId;
    protected String campaigns;

    protected String zoneTopiaId;

    protected List<ToolsCouplingDto> toolsCouplingDtos;

    public void setEffectiveService(EffectiveCropCycleService effectiveService) {
        this.effectiveService = effectiveService;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setAgrosystInterventionType(AgrosystInterventionType agrosystInterventionType) {
        this.agrosystInterventionType = agrosystInterventionType;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public void setZoneTopiaId(String zoneTopiaId) {
        this.zoneTopiaId = zoneTopiaId;
    }

    @Override
    public String execute() {
        if (Strings.isNullOrEmpty(zoneTopiaId)) {
            toolsCouplingDtos = practicedSystemService.getToolsCouplingModel(growingSystemId, campaigns, agrosystInterventionType);
        } else {
            toolsCouplingDtos = effectiveService.getToolsCouplingModel(zoneTopiaId, agrosystInterventionType);
        }
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return toolsCouplingDtos;
    }

}
