package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadEffectiveZonesForCopyJson.java 4534 2014-11-07 10:42:21Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/LoadEffectiveZonesForCopyJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.effective.CopyPasteZoneDabByCampaigns;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Created by davidcosse on 01/07/14.
 */
public class LoadEffectiveZonesForCopyJson extends AbstractJsonAction {

    protected String zoneId;

    protected EffectiveCropCycleService effectiveCropCycleService;

    protected CopyPasteZoneDabByCampaigns result;

    @Override
    public String execute() throws Exception {
        result = effectiveCropCycleService.getAvailableZonesForCopy(zoneId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return result;
    }

    public String getZoneId() {
        return zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public EffectiveCropCycleService getEffectiveCropCycleService() {
        return effectiveCropCycleService;
    }

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }
}
