package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadAvailableZoneForDuplicationJson.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/LoadAvailableZoneForDuplicationJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadAvailableZoneForDuplicationJson extends AbstractJsonAction {
    
    private static final long serialVersionUID = 1L;
    
    protected String zoneId;

    protected PlotService plotService;

    protected List<Zone> zones;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public String execute() {

        zones = plotService.getZonesWithoutCycle(zoneId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return zones;
    }
}
