package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveCropCyclesExport.java 3921 2014-03-31 11:03:47Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveCropCyclesExport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author David Cossé
 */
public class EffectiveCropCyclesExport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(EffectiveCropCyclesExport.class);
    private static final long serialVersionUID = -4679799491132289719L;

    protected List<String> selectedEffectiveCropCycleIds;

    protected transient EffectiveCropCycleService effectiveCropCycleService;

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "application/vnd.ms-excel",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        return SUCCESS;
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = effectiveCropCycleService.exportEffectiveCropCyclesAsXlsStream(selectedEffectiveCropCycleIds);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate xsl", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = "Interventions-culturales-realisees-export.xls";
        return filename;
    }

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setSelectedEffectiveCropCycleIds(List<String> selectedEffectiveCropCycleIds) {
        this.selectedEffectiveCropCycleIds = selectedEffectiveCropCycleIds;
    }
}
