package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainMaterielsCopy.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainMaterielsCopy.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.gson.reflect.TypeToken;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import java.lang.reflect.Type;
import java.util.List;

/**
 * Created by davidcosse on 30/06/14.
 */
public class DomainMaterielsCopy extends AbstractJsonAction {
    
    private static final long serialVersionUID = 1L;
    
    protected String fromDomain;

    protected List<String> toDomains;

    protected Boolean includeToolsCouplings;

    protected List<Equipment> equipments;
    protected List<ToolsCoupling> toolsCouplings;

    protected DomainService domainService;

    protected Object result;

    @Override
    @Action(results = {
            @Result(name = ERROR, type = "agrosyst-json")})
    public String execute() throws Exception {
        try {
            result = domainService.copyTools(fromDomain, toDomains, includeToolsCouplings, equipments, toolsCouplings);
            return SUCCESS;
        } catch (IllegalArgumentException e) {
            result = e.getClass().getSimpleName();
            return ERROR;
        } catch (Exception e) {
            return ERROR;
        }

    }

    public void setFromDomain(String fromDomain) {
        this.fromDomain = fromDomain;
    }

    public void setIncludeToolsCouplings(Boolean includeToolsCouplings) {
        this.includeToolsCouplings = includeToolsCouplings;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setToDomains(String json) {
        Type type = new TypeToken<List<String>>() {
        }.getType();
        this.toDomains = getGson().fromJson(json, type);
    }

    @Override
    public Object getJsonData() {
        return result;
    }

    public void setEquipmentsJson(String json) {
        Type type = new TypeToken<List<Equipment>>() {
        }.getType();
        this.equipments = getGson().fromJson(json, type);
    }

    public void setToolsCouplingsJson(String json) {
        Type type = new TypeToken<List<ToolsCoupling>>() {
        }.getType();
        this.toolsCouplings = getGson().fromJson(json, type);
    }
}
