package fr.inra.agrosyst.web.actions.context;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ContextChooseRaw.java 4488 2014-10-29 13:17:42Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/context/ContextChooseRaw.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;
import java.util.Set;

import fr.inra.agrosyst.api.entities.TypeDEPHY;
import org.apache.struts2.convention.annotation.Action;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class ContextChooseRaw extends AbstractJsonAction implements Preparable {

    private static final long serialVersionUID = 8311330060409844511L;

    protected List<Integer> campaignsList;
    protected ResultList<DomainDto> domains;
    protected ResultList<Network> networks;
    protected ResultList<GrowingPlanDto> growingPlans;
    protected ResultList<GrowingSystemDto> growingSystems;
    protected NavigationContext navigationContext;

    protected Set<Integer> selectedCampaigns;
    protected Set<String> selectedNetworks;
    protected Set<String> selectedDomains;
    protected Set<String> selectedGrowingPlans;
    protected Set<String> selectedGrowingSystems;

    @Override
    public void prepare() throws Exception {
    }

    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    public void setSelectedNetworks(Set<String> selectedNetworks) {
        this.selectedNetworks = selectedNetworks;
    }

    public void setSelectedDomains(Set<String> selectedDomains) {
        this.selectedDomains = selectedDomains;
    }

    public void setSelectedGrowingPlans(Set<String> selectedGrowingPlans) {
        this.selectedGrowingPlans = selectedGrowingPlans;
    }

    public void setSelectedGrowingSystems(Set<String> selectedGrowingSystems) {
        this.selectedGrowingSystems = selectedGrowingSystems;
    }

    @Override
    @Action("context-choose-raw-input")
    public String input() throws Exception {
        navigationContext = super.getNavigationContext();

        Set<Integer> campaignForFiltering = navigationContext.getCampaigns();
        Set<String> networksForFiltering = navigationContext.getNetworks();
        Set<String> domainsForFiltering = navigationContext.getDomains();
        Set<String> growingPlansForFiltering = navigationContext.getGrowingPlans();

        campaignsList = navigationContextService.getAllCampaigns();
        networks = navigationContextService.getAllNetworks();
        domains = navigationContextService.getAllDomainsForCampaign(campaignForFiltering, networksForFiltering);
        growingPlans = navigationContextService.getAllGrowingPlansForDomains(campaignForFiltering, domainsForFiltering, networksForFiltering);
        growingSystems = navigationContextService.getAllGrowingSystemsForGrowingPlans(campaignForFiltering, domainsForFiltering, growingPlansForFiltering, networksForFiltering);
        return INPUT;
    }

    @Override
    public String execute() throws Exception {

        NavigationContext newNavigationContext = new NavigationContext();
        if (selectedCampaigns != null) {
            newNavigationContext.getCampaigns().addAll(selectedCampaigns);
        }

        if (selectedNetworks != null) {
            newNavigationContext.getNetworks().addAll(selectedNetworks);
        }

        if (selectedDomains != null) {
            newNavigationContext.getDomains().addAll(selectedDomains);
        }

        if (selectedGrowingPlans != null) {
            newNavigationContext.getGrowingPlans().addAll(selectedGrowingPlans);
        }

        if (selectedGrowingSystems != null) {
            newNavigationContext.getGrowingSystems().addAll(selectedGrowingSystems);
        }

        verifyAndSaveNavigationContext(newNavigationContext);

        return SUCCESS;
    }

    protected Map<String, Boolean> toMap(Set<String> set) {
        Map<String, Boolean> result;
        if (set.isEmpty()) {
            result = Maps.newHashMap();
        } else {
            result = Maps.toMap(set, GET_TRUE);
        }
        return result;
    }

    public List<String> getCampaigns() {
        List<String> result = Lists.newArrayList();
        if (!campaignsList.isEmpty()) {
            Iterable<String> campaignStr = Iterables.transform(campaignsList, TO_STRING);
            Iterables.addAll(result, campaignStr);
        }
        return result;
    }

    public Map<String, Boolean> getSelectedCampaigns() {
        Set<Integer> campaigns = navigationContext.getCampaigns();
        Map<String, Boolean> result;
        if (!campaigns.isEmpty()) {
            Iterable<String> campaignStr = Iterables.transform(campaigns, TO_STRING);
            result = Maps.toMap(campaignStr, GET_TRUE);
        } else {
            result = Maps.newHashMap();
        }
        return result;
    }

    public ResultList<Network> getNetworks() {
        return networks;
    }

    public Map<String, Boolean> getSelectedNetworks() {
        Set<String> networks = navigationContext.getNetworks();
        Map<String, Boolean> result = toMap(networks);
        return result;
    }

    public ResultList<DomainDto> getDomains() {
        return domains;
    }

    public Map<String, Boolean> getSelectedDomains() {
        Set<String> domains = navigationContext.getDomains();
        Map<String, Boolean> result = toMap(domains);
        return result;
    }

    public ResultList<GrowingPlanDto> getGrowingPlans() {
        return growingPlans;
    }

    public Map<String, Boolean> getSelectedGrowingPlans() {
        Set<String> dispositifs = navigationContext.getGrowingPlans();
        Map<String, Boolean>  result = toMap(dispositifs);
        return result;
    }

    public ResultList<GrowingSystemDto> getGrowingSystems() {
        return growingSystems;
    }

    public Map<String, Boolean> getSelectedGrowingSystems() {
        Set<String> sdcs = navigationContext.getGrowingSystems();
        Map<String, Boolean> result = toMap(sdcs);
        return result;
    }

    public NavigationContext getNavigationContext() {
        return navigationContext;
    }

    public Map<DomainType, String> getDomainTypes() {
        return getEnumAsMap(DomainType.values());
    }

    public Map<Sector, String> getSectors() {
        return getEnumAsMap(Sector.values());
    }

    @Override
    public Object getJsonData() {
        return new Object();
    }

    public Map<TypeDEPHY, String> getDelphyTypes() {
        return getEnumAsMap(TypeDEPHY.values());
    }

}
