package fr.inra.agrosyst.web.actions.auth;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: FeedbackJson.java 4415 2014-10-13 20:56:09Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/auth/FeedbackJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import javax.imageio.ImageIO;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Cette action récupère le formulaire de feedback (en json) et l'envoi par mail.
 */
public class FeedbackJson extends AbstractJsonAction {

    private static final long serialVersionUID = -6415308969543420930L;

    private static final Log log = LogFactory.getLog(FeedbackJson.class);

    protected transient UserService userService;

    protected String clientAppVersion;

    protected String feedback;

    protected String feedbackCategory;

    protected String env;

    protected String location;

    protected String locationTitle;

    protected String referer;

    protected String requested;

    /** Base 64 url encoded data (png format). */
    protected String screenshot;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setClientAppVersion(String clientAppVersion) {
        this.clientAppVersion = clientAppVersion;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setLocationTitle(String locationTitle) {
        this.locationTitle = locationTitle;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public void setFeedbackCategory(String feedbackCategory) {
        this.feedbackCategory = feedbackCategory;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setRequested(String requested) {
        this.requested = requested;
    }

    public void setScreenshot(String screenshot) {
        // data:image/png;base64, ...
        this.screenshot = screenshot;
    }

    @Override
    public String execute() throws Exception {
        String envInfo = Strings.nullToEmpty(env);
        envInfo += "Adresse IP : " + servletRequest.getRemoteAddr() + "\n";
        envInfo += "Session ID : " + getSessionId() + "\n";
        envInfo += "Version cliente : " + clientAppVersion + "\n";
        envInfo += "Version web : " + getConfig().getApplicationVersion() + "\n";

        byte[] imgData = convertBase64ToImage(screenshot);

        userService.sendFeedback(envInfo, location, locationTitle, feedbackCategory, feedback, requested, referer, imgData);
        return SUCCESS;
    }
    
    protected byte[] convertBase64ToImage(String fullBase64) {
        byte[] result = null;
        
        if (fullBase64 != null) {
            try {
                // extract base 64 data
                String base64Data = fullBase64.substring(screenshot.indexOf(",") + 1);
                byte[] imgData = Base64.decodeBase64(base64Data);
                
                // convert to image
                ByteArrayInputStream is = new ByteArrayInputStream(imgData);
                BufferedImage image = ImageIO.read(is);
                is.close();
    
                // convert image to byte array
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write(image, "jpeg", os);
                result = os.toByteArray();
                os.close();
            } catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't convert base64 data to image", ex);
                }
            }
        }

        return result;
    }
    @Override
    public Object getJsonData() {
        return null;
    }
}
