package fr.inra.agrosyst.web.actions;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystJsonResultSupport.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/AgrosystJsonResultSupport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.IOException;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.Action;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.StrutsResultSupport;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.opensymphony.xwork2.ActionInvocation;

import fr.inra.agrosyst.commons.gson.AgrosystGsonSupplier;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class AgrosystJsonResultSupport extends StrutsResultSupport {

    private static final long serialVersionUID = 4604320651695670319L;

    private static final Log log = LogFactory.getLog(AgrosystJsonResultSupport.class);

    protected transient Gson gson;

    public Gson getGson() {
        if (gson == null) {
            gson = new AgrosystGsonSupplier().get();
        }
        return gson;
    }

    @Override
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {

        Object jsonData = invocation.getStack().findValue("jsonData");

        String json = getGson().toJson(jsonData);

        // Work-arround for IE to not display download dialog for json result
        // see https://github.com/blueimp/jQuery-File-Upload/issues/1795
        HttpServletRequest servletRequest = (HttpServletRequest) invocation.getInvocationContext().get(HTTP_REQUEST);
        HttpServletResponse servletResponse = (HttpServletResponse) invocation.getInvocationContext().get(HTTP_RESPONSE);

        if (invocation.getResultCode().equals(Action.ERROR)) {
            servletResponse.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        }

        servletResponse.setCharacterEncoding(Charsets.UTF_8.name());
        if (servletRequest.getHeader("accept").contains("application/json")) {
            servletResponse.setContentType("application/json");
        } else {
            // IE workaround
            servletResponse.setContentType("text/plain");
        }

        try {
            ServletOutputStream outputStream = servletResponse.getOutputStream();
            byte[] jsonBytes = json.getBytes(Charsets.UTF_8); // On transforme en bytes pour assurer l'encodage
            outputStream.write(jsonBytes);
        } catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("Unable to write JSON output into Servlet Response");
            }
        }

    }

}
