package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebNotification.java 2861 2014-01-24 10:20:46Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebNotification.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import com.google.common.collect.ImmutableMap;

public class AgrosystWebNotification implements Serializable {

    private static final long serialVersionUID = 1650671999712757336L;

    protected String text;

    protected AgrosystWebNotificationLink link;

    public AgrosystWebNotification(String text) {
        this.text = text;
    }

    public static AgrosystWebNotification of(String text, Object... args) {
        return new AgrosystWebNotification(String.format(text, args));
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public AgrosystWebNotificationLink getLink() {
        return link;
    }

    public void setLink(AgrosystWebNotificationLink link) {
        this.link = link;
    }

    public AgrosystWebNotification link(String label, String namespace, String action, String k1, String v1) {
        this.link = new AgrosystWebNotificationLink(label,namespace ,action, ImmutableMap.of(k1, v1));
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AgrosystWebNotification that = (AgrosystWebNotification) o;

        if (link != null ? !link.equals(that.link) : that.link != null) return false;
        if (text != null ? !text.equals(that.text) : that.text != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = text != null ? text.hashCode() : 0;
        result = 31 * result + (link != null ? link.hashCode() : 0);
        return result;
    }

}
