package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebApplicationListener.java 3944 2014-03-31 17:07:51Z ymartel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebApplicationListener.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class AgrosystWebApplicationListener implements ServletContextListener {

    private static final Log log = LogFactory.getLog(AgrosystWebApplicationListener.class);

    protected AgrosystWebApplicationContext context;

    @Override
    public void contextInitialized(ServletContextEvent sce) {

        if (log.isInfoEnabled()) {
            log.info("Initializing Agrosyst Web Module");
        }

        context = new AgrosystWebApplicationContext();
        ServletContext servletContext = sce.getServletContext();
        context.init(servletContext);

        servletContext.setAttribute(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER, context);

        context.checkForDemoData();
        context.initApplicationBanners(servletContext);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info("Destroy Agrosyst Web Module");
        }

        /*Set<PooledDataSource> pooledDataSourceSet = (Set<PooledDataSource>) C3P0Registry.getPooledDataSources();

        for (PooledDataSource dataSource : pooledDataSourceSet) {
            try {
                dataSource.hardReset();
                dataSource.close();
            } catch (SQLException e) {

            }
        }*/

        context.close();

        /*try {
            Thread.sleep(2000); //Let give it time...it is enough?...probably....
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
          Driver driver = drivers.nextElement();
          try {
            DriverManager.deregisterDriver(driver);
          } catch (SQLException e) {

          }
        }*/
    }
}
