package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersListAllJson.java 3400 2014-02-21 16:28:46Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersListAllJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.services.AgrosystFilter;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserFilter;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class UsersListAllJson extends AbstractJsonAction {

    private static final long serialVersionUID = 8714662434791990669L;

    protected transient UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected List<UserDto> users;

    @Override
    public String execute() {
        UserFilter filter = new UserFilter();
        filter.setPageSize(AgrosystFilter.ALL_PAGE_SIZE);
        users = userService.getFilteredUsers(filter, false).getElements();

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return users;
    }

}
