package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GetGrowingSystemCampaignsJson.java 3369 2014-02-20 15:27:52Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/GetGrowingSystemCampaignsJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class GetGrowingSystemCampaignsJson extends AbstractJsonAction {

    private static final long serialVersionUID = 6867073373068008791L;

    protected transient GrowingSystemService growingSystemService;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    protected String growingSystemCode;

    protected List<Integer> campaigns;

    public void setGrowingSystemCode(String growingSystemCode) {
        this.growingSystemCode = growingSystemCode;
    }

    @Override
    public String execute() throws Exception {
        campaigns = growingSystemService.getGrowingSystemCampaigns(growingSystemCode);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return campaigns;
    }

}
