package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ValidatePracticedSystems.java 3474 2014-02-25 14:36:15Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/ValidatePracticedSystems.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Validation d'un système synthétisé
 *
 * @author Arnaud Thimel (Code Lutin)
 * @since 0.11
 */
public class ValidatePracticedSystems extends AbstractAgrosystAction {

    private static final long serialVersionUID = 8593083289673832006L;

    protected transient PracticedSystemService practicedSystemService;

    protected List<String> practicedSystemIds;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setPracticedSystemIds(List<String> practicedSystemIds) {
        this.practicedSystemIds = practicedSystemIds;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "practiced-systems-list"})})
    public String execute() throws Exception {
        for (String practicedSystemId : practicedSystemIds) {
            PracticedSystem practicedSystem = practicedSystemService.validate(practicedSystemId);
            notificationSupport.practicedSystemValidated(practicedSystem);
        }
        return SUCCESS;
    }

}
