package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsList.java 3453 2014-02-25 00:50:50Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class PracticedSystemsList extends AbstractAgrosystAction {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 3084229660685255829L;

    protected transient PracticedSystemService practicedSystemService;

    protected PracticedSystemFilter practicedSystemFilter;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    /**
     * Initial list data.
     */
    protected ResultList<PracticedSystemDto> practicedSystems;

    @Override
    public String execute() throws Exception {

        NavigationContext navigationContext = getNavigationContext();
        practicedSystemFilter = new PracticedSystemFilter();
        practicedSystemFilter.setNavigationContext(navigationContext);
        practicedSystemFilter.setPageSize(getConfig().getListResultsPerPage());
        practicedSystemFilter.setActive(Boolean.TRUE);

        practicedSystems = practicedSystemService.getFilteredPracticedSystemsDto(practicedSystemFilter);
        return SUCCESS;
    }

    public ResultList<PracticedSystemDto> getPracticedSystems() {
        return practicedSystems;
    }

    public PracticedSystemFilter getPracticedSystemFilter() {
        return practicedSystemFilter;
    }
}
