package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsExport.java 3921 2014-03-31 11:03:47Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsExport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;

/**
 * @author David Cossé
 */
public class PracticedSystemsExport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(PracticedSystemsExport.class);
    private static final long serialVersionUID = -4679799491132289719L;

    protected List<String> practicedSystemIds;

    protected transient PracticedSystemService service;

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "application/vnd.ms-excel",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        return SUCCESS;
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = service.exportPracticedSystemsAsXlsStream(practicedSystemIds);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate xsl", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = "Systemes-synthetises-export.xls";
        return filename;
    }

    public void setService(PracticedSystemService service) {
        this.service = service;
    }

    public void setPracticedSystemIds(List<String> practicedSystemIds) {
        this.practicedSystemIds = practicedSystemIds;
    }
}
