package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsDuplicate.java 3735 2014-03-12 15:50:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsDuplicate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Duplicate single domain.
 * 
 * @author Eric Chatellier
 */
public class PracticedSystemsDuplicate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 3763987457979325440L;

    /** Single practiced system to duplicate. */
    protected String practicedSystemId;

    protected String growingSystemId;

    /** Service. */
    protected transient PracticedSystemService practicedSystemService;

    /** Practiced system. */
    protected PracticedSystem practicedSystem;

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setPracticedSystemId(String practicedSystemId) {
        this.practicedSystemId = practicedSystemId;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "practiced-systems-edit-input", "practicedSystemTopiaId", "${practicedSystem.topiaId}"}),
            @Result(name = ERROR, type = "redirectAction", params = {"actionName", "practiced-systems-list"})
    })
    public String execute() throws Exception {
        if (Strings.isNullOrEmpty(practicedSystemId) || Strings.isNullOrEmpty(growingSystemId)) {
            notificationSupport.practicedSystemNotDuplicable(practicedSystemId, growingSystemId);
            return ERROR;
        }
        practicedSystem = practicedSystemService.duplicatePracticedSystem(practicedSystemId, growingSystemId);
        notificationSupport.practicedSystemDuplicate();
        return SUCCESS;

    }

    public PracticedSystem getPracticedSystem() {
        return practicedSystem;
    }
}
