package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadActaReferenceDoseJson.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadActaReferenceDoseJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class LoadActaReferenceDoseJson extends AbstractJsonAction {

    private static final long serialVersionUID = 888641029321686474L;

    private static final Log log = LogFactory.getLog(LoadActaReferenceDoseJson.class);

    protected transient ReferentialService referentialService;

    protected String phytoProductId;
    protected Set<String> speciesId;

    protected RefActaDosageSPC dose;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setPhytoProductId(String phytoProductId) {
        this.phytoProductId = phytoProductId;
    }

    public void setSpeciesId(Set<String> speciesId) {
        this.speciesId = speciesId;
    }

    @Override
    public String execute() throws Exception {
        dose = referentialService.computeActaReferenceDose(phytoProductId, speciesId);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return dose;
    }

}
