package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsExport.java 3929 2014-03-31 13:00:58Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsExport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.domains.DomainsExport;

/**
 * Export XSL d'un ensemble de parcelles.
 *
 * @author Eric Chatellier
 */
public class PlotsExport extends AbstractAgrosystAction {

    private static final long serialVersionUID = -1618279547328450777L;

    private static final Log log = LogFactory.getLog(DomainsExport.class);

    protected transient PlotService plotService;

    protected List<String> plotTopiaIds;

    public void setPlotTopiaIds(List<String> plotTopiaIds) {
        this.plotTopiaIds = plotTopiaIds;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "application/vnd.ms-excel",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        return SUCCESS;
    }
    
    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = plotService.exportPlotsAsXlsStream(plotTopiaIds);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate xsl", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = "parcelle-export.xls";
        return filename;
    }
}
