package fr.inra.agrosyst.web.actions.performances;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PerformancesList.java 3828 2014-03-20 17:20:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/performances/PerformancesList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.performance.PerformanceDto;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.performance.PerformanceFilter;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class PerformancesList extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1180723133330637375L;

    protected transient PerformanceService performanceService;

    protected boolean practiced;

    protected PerformanceFilter performanceFilter;

    protected ResultList<PerformanceDto> performances;

    public void setPracticed(boolean practiced) {
        this.practiced = practiced;
    }

    public boolean isPracticed() {
        return practiced;
    }

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    public String execute() {
        performanceFilter = new PerformanceFilter();
        performanceFilter.setPageSize(getConfig().getListResultsPerPage());
        performanceFilter.setActive(Boolean.TRUE);
        performanceFilter.setPracticed(practiced);
        performances = performanceService.getFilteredPerformances(performanceFilter);
        return SUCCESS;
    }

    public ResultList<PerformanceDto> getPerformances() {
        return performances;
    }
    
    public PerformanceFilter getPerformanceFilter() {
        return performanceFilter;
    }
}
