package fr.inra.agrosyst.web.actions.performances;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PerformancesEditJson.java 3831 2014-03-20 18:30:28Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/performances/PerformancesEditJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

import com.google.gson.reflect.TypeToken;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.struts2.convention.annotation.Action;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Actions json de la page d'edition des performances.
 * 
 * @author Eric Chatellier
 */
public class PerformancesEditJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 525633506544808582L;

    protected transient GrowingSystemService growingSystemService;
    
    protected transient PerformanceService performanceService;

    protected String domainIds;

    protected String plotIds;

    protected Object jsonData;

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setDomainIds(String domainIds) {
        this.domainIds = domainIds;
    }

    public void setPlotIds(String plotIds) {
        this.plotIds = plotIds;
    }

    @Action("performances-edit-growing-systems-list-json")
    public String listGrowingSystems() {
        Type type = new TypeToken<List<String>>() {}.getType();
        List<String> domainIdsList = getGson().fromJson(domainIds, type);
        if (CollectionUtils.isEmpty(domainIdsList)) {
            jsonData = Collections.emptyList();
        } else {
            GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
            growingSystemFilter.setAllPageSize();
            growingSystemFilter.setActive(true);
            NavigationContext navigationContext2 = new NavigationContext(getNavigationContext());
            navigationContext2.setDomains(Sets.newHashSet(domainIdsList));
            growingSystemFilter.setNavigationContext(navigationContext2);
            jsonData = growingSystemService.getFilteredGrowingSystems(growingSystemFilter).getElements();
        }
        return SUCCESS;
    }
    
    @Action("performances-edit-plots-list-json")
    public String listPlots() {
        Type type = new TypeToken<List<String>>() {}.getType();
        List<String> domainIdsList = getGson().fromJson(domainIds, type);
        if (CollectionUtils.isEmpty(domainIdsList)) {
            jsonData = Collections.emptyList();
        } else {
            jsonData = performanceService.getPlots(domainIdsList);
        }
        return SUCCESS;
    }
    
    @Action("performances-edit-zones-list-json")
    public String listZones() {
        Type type = new TypeToken<List<String>>() {}.getType();
        List<String> plotIdsList = getGson().fromJson(plotIds, type);
        if (CollectionUtils.isEmpty(plotIdsList)) {
            jsonData = Collections.emptyList();
        } else {
            jsonData = performanceService.getZones(plotIdsList);
        }
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }
}
