package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: NetworksImport.java 3460 2014-02-25 09:52:01Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/NetworksImport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;

/**
 * Import de réseau par lot.
 *
 * @author Eric Chatellier
 */
public class NetworksImport extends AbstractAdminAction {

    private static final Log log = LogFactory.getLog(NetworksImport.class);

    private static final long serialVersionUID = 5338924873719324729L;

    protected transient NetworkService networkService;

    protected File networkFile;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setNetworkFile(File networkFile) {
        this.networkFile = networkFile;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {
            "namespace", "/networks", "actionName", "networks-list"})})
    public String execute() throws Exception {
        try {
            ImportResult result = networkService.importNetworks(new FileInputStream(networkFile));
            
            notificationSupport.networkImported(result);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import user file", ex);
            }
        }
        return SUCCESS;
    }

}
