package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DecisionRulesList.java 3289 2014-02-18 09:31:34Z ymartel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/DecisionRulesList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.managementmode.DecisionRuleFilter;
import fr.inra.agrosyst.api.services.managementmode.DecisionRulesDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Decision rule list action.
 * 
 * @author Eric Chatellier
 */
public class DecisionRulesList extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -8916181887544412258L;

    protected transient ManagementModeService managementModeService;

    protected ResultList<DecisionRulesDto> decisionRules;

    protected DecisionRuleFilter decisionRuleFilter;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    @Override
    public String execute() throws Exception {
        NavigationContext navigationContext = getNavigationContext();
        decisionRuleFilter = new DecisionRuleFilter();
        decisionRuleFilter.setNavigationContext(navigationContext);
        decisionRuleFilter.setPageSize(getConfig().getListResultsPerPage());
        decisionRuleFilter.setActive(Boolean.TRUE);

        decisionRules = managementModeService.getFilteredDecisionRules(decisionRuleFilter);

        return SUCCESS;
    }

    public ResultList<DecisionRulesDto> getDecisionRules() {
        return decisionRules;
    }

    public Map<AgrosystInterventionType, String> getAgrosystInterventionTypes() {
        return getEnumAsMap(AgrosystInterventionType.values());
    }

    public DecisionRuleFilter getDecisionRuleFilter() {
        return decisionRuleFilter;
    }
}
