package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingSystemsUnactivate.java 3241 2014-02-14 09:40:30Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/GrowingSystemsUnactivate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author cosse
 *
 */
public class GrowingSystemsUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 5109566144227877080L;

    protected transient GrowingSystemService growingSystemService;

    protected List<String> growingSystemIds;

    protected boolean activate;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setGrowingSystemIds(List<String> growingSystemIds) {
        this.growingSystemIds = growingSystemIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "growing-systems-list" }) })
    public String execute() throws Exception {
        growingSystemService.unactivateGrowingSystems(growingSystemIds, activate);
        return SUCCESS;
    }
}
