package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadEffectiveZonesForCopyJson.java 4123 2014-07-03 15:28:59Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/LoadEffectiveZonesForCopyJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.effective.CopyPasteZoneDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * Created by davidcosse on 01/07/14.
 */
public class LoadEffectiveZonesForCopyJson extends AbstractJsonAction {

    protected String zoneId;

    protected String cropId;

    protected EffectiveCropCycleService effectiveCropCycleService;

    protected List<CopyPasteZoneDto> result;

    @Override
    public String execute() throws Exception {
        result = effectiveCropCycleService.getAvailableZonesForCopy(zoneId, cropId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return result;
    }

    public String getZoneId() {
        return zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getCropId() {
        return cropId;
    }

    public void setCropId(String cropId) {
        this.cropId = cropId;
    }

    public EffectiveCropCycleService getEffectiveCropCycleService() {
        return effectiveCropCycleService;
    }

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }
}
