package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveInterventionsCopy.java 4168 2014-07-11 22:02:19Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveInterventionsCopy.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.gson.reflect.TypeToken;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import fr.inra.agrosyst.api.services.effective.TargetedZones;

import java.lang.reflect.Type;
import java.util.List;

/**
 * Created by davidcosse on 02/07/14.
 */
public class EffectiveInterventionsCopy extends AbstractJsonAction {

    protected List<TargetedZones> targetedZones;

    protected List<EffectiveInterventionDto> interventionDtos;

    protected EffectiveCropCycleService service;

    @Override
    public String execute() throws Exception {
        if (targetedZones != null) {
            service.copyIntervention(targetedZones, interventionDtos);
            return SUCCESS;
        }
        return ERROR;
    }

    @Override
    public Object getJsonData() {
        return null;
    }

    public void setInterventionDtos(String json) {
        Type type = new TypeToken<List<EffectiveInterventionDto>>() {}.getType();
        this.interventionDtos = getGson().fromJson(json, type);
    }

    public void setTargetedZones(String json) {
        Type type = new TypeToken<List<TargetedZones>>() {}.getType();
        this.targetedZones = getGson().fromJson(json, type);
    }

    public void setService(EffectiveCropCycleService service) {
        this.service = service;
    }

}
