package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ListRefLocationJson.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/ListRefLocationJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Action de retourner la liste des communes
 *
 * @author David Cossé
 */
public class ListRefLocationJson extends AbstractJsonAction {

    private static final long serialVersionUID = 3930228731417892430L;

    protected transient ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    protected List<RefLocation> communes;

    protected String term;

    @Override
    public String execute() {
        communes = referentialService.findActiveCommunes(term);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return communes;
    }

    @Override
    public String input() throws Exception {
        return INPUT;
    }

    public String getTerm() {
        return term;
    }

    public void setTerm(String term) {
        this.term = term;
    }
}
