package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsImport.java 3880 2014-03-27 11:18:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsImport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Import domain XLS file.
 * 
 * @author Eric Chatellier
 */
@Results({
        @Result(type = "redirectAction", name = "input", params = {"actionName", "domains-list", "importFileError", "true"})
})
public class DomainsImport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(DomainsImport.class);

    private static final long serialVersionUID = 2031204987636332755L;

    protected File file;

    public void setFile(File file) {
        this.file = file;
    }

    protected transient DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    @Action(results = {
            @Result(type = "redirectAction", params = {"actionName", "domains-list"})})
    public String execute() throws Exception {
        InputStream stream = null;
        try {
            stream = new FileInputStream(file);
            domainService.importDomainForXlsStream(stream);
            notificationSupport.importSuccess();
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import xls file", ex);
            }
            notificationSupport.importError(ex.getMessage());
        } finally {
            IOUtils.closeQuietly(stream);
        }
        return SUCCESS;
    }
}
