package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsEditJson.java 4221 2014-07-22 08:06:57Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsEditJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.ArrayList;
import java.util.List;

import org.apache.struts2.convention.annotation.Action;

import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.referential.TypeMaterielFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Permet de gerer les methode json pour l'edition d'un domaine.
 * 
 * @author Eric Chatellier
 */
public class DomainsEditJson extends AbstractJsonAction implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4134613183262825235L;

    protected transient ReferentialService referentialService;

    protected transient DomainService domainService;

    /** Filter for materiel* actions. */
    protected String filter;

    /** Region for RefSolArvalis actions. */
    protected Integer regionCode;

    /** otex18code form edit domain otex code. */
    protected Integer otex18code;

    /** Domain name (to check existance). */
    protected String domainName;

    protected Object data;

    protected String toolsCouplingCode;

    protected String actionTopiaId;

    protected String materielId;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Override
    public void prepare() throws Exception {
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setRegionCode(Integer regionCode) {
        this.regionCode = regionCode;
    }

    public void setOtex18code(Integer otex18code) {
        this.otex18code = otex18code;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Action("domain-edit-materiel-type2-json")
    public String listMaterielType2() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentialService.getTypeMateriel2List(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-type3-json")
    public String listMaterielType3() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentialService.getTypeMateriel3List(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-type4-json")
    public String listMaterielType4() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentialService.getTypeMateriel4List(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-unite-json")
    public String listMaterielUnite() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentialService.getMaterielUniteMap(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-all-json")
    public String listMaterielAll() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = new ArrayList<Object>(4);
        ((List<Object>)data).add(referentialService.getTypeMateriel2List(typeMaterielFilter));
        ((List<Object>)data).add(referentialService.getTypeMateriel3List(typeMaterielFilter));
        ((List<Object>)data).add(referentialService.getTypeMateriel4List(typeMaterielFilter));
        ((List<Object>)data).add(referentialService.getMaterielUniteMap(typeMaterielFilter));
        return SUCCESS;
    }

    @Action("domain-edit-materiel-find-materiel")
    public String getMateriel() {
        data = referentialService.findMateriel(materielId);
        return SUCCESS;
    }

    @Action("domain-edit-sol-arvalis-list-json")
    public String listSolArvalis() {
        data = referentialService.getSolArvalis(regionCode);
        return SUCCESS;
    }

    @Action("get-ref-otex-json")
    public String listRefOtex70() {
        data = referentialService.findAllActiveCodeOtex70ByOtex18code(otex18code);
        return SUCCESS;
    }

    @Action("check-domain-name-json")
    public String checkDomainName() {
        data = domainService.checkDomainExistence(domainName);
        return SUCCESS;
    }

//    @Action("check-action-exist-on-tools-coupling-json")
//    public String checkActionExistOnToolsCoupling() {
//        data = domainService.checkActionExistOnToolsCoupling(toolsCouplingCode);
//        return SUCCESS;
//    }

//    @Action("check-action-exist-on-main-action-json")
//    public String checkActionExistOnMainAction() {
//        data = domainService. checkActionExistOnMainAction(toolsCouplingCode, actionTopiaId);
//        return SUCCESS;
//    }

    @Override
    public Object getJsonData() {
        return data;
    }

    public void setToolsCouplingCode(String toolsCouplingCode) {
        this.toolsCouplingCode = toolsCouplingCode;
    }

    public void setActionTopiaId(String actionTopiaId) {
        this.actionTopiaId = actionTopiaId;
    }

    public void setMaterielId(String materielId) {
        this.materielId = materielId;
    }
}
