package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AttachmentsRaw.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/AttachmentsRaw.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.AttachmentMetadata;
import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * This is the default action used to upload a file attached to a given object reference ID.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class AttachmentsRaw extends AbstractAgrosystAction {

    private static final long serialVersionUID = 1864154104471757665L;

    protected transient AttachmentService attachmentService;

    protected List<AttachmentMetadata> attachmentMetadatas;

    protected String objectReferenceId;

    protected boolean readOnly;

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public void setObjectReferenceId(String objectReferenceId) {
        this.objectReferenceId = objectReferenceId;
    }

    @Override
    public String execute() throws Exception {
        attachmentMetadatas = attachmentService.getAttachmentMetadatas(objectReferenceId);
        readOnly = !authorizationService.areAttachmentsAddableOrDeletable(objectReferenceId);
        return SUCCESS;
    }

    public List<AttachmentMetadata> getAttachmentMetadatas() {
        return attachmentMetadatas;
    }

    public String getObjectReferenceId() {
        return objectReferenceId;
    }

    public boolean isReadOnly() {
        return readOnly;
    }
}
