package fr.inra.agrosyst.web.actions.auth;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RetrievePassword.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.1.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/auth/RetrievePassword.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class RetrievePassword extends AbstractAgrosystAction {

    private static final long serialVersionUID = 3501789225489989672L;

    protected transient UserService userService;

    protected String userId;
    protected String token;
    protected String password;
    protected String passwordCheck;
    protected UserDto user;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordCheck(String passwordCheck) {
        this.passwordCheck = passwordCheck;
    }

    @Override
    @Action("retrieve-password-input")
    public String input() throws Exception {
        initForInput();
        return super.input();
    }

    @Override
    protected void initForInput() {
        user = userService.preparePasswordChange(token, userId);
        if (user == null) {
            addActionError("Token invalide");
        }
    }

    @Override
    public void validate() {
        if (Strings.isNullOrEmpty(password)) {
            addFieldError("password", "Le mot de passe est obligatoire");
        } else if (!password.equals(passwordCheck)) {
            addFieldError("passwordCheck", "Les mots de passe entrés ne correspondent pas");
        }
        if (hasErrors()) {
            initForInput();
        }
    }

    @Override
    public String execute() throws Exception {
        boolean success = userService.updatePassword(token, userId, password);
        if (success) {
            addActionMessage("Mot de passe mis à jour, merci de vous reconnecter");
        } else {
            input();
        }
        return INPUT;
    }

    public UserDto getUser() {
        return user;
    }

    public String getUserId() {
        return userId;
    }

    public String getToken() {
        return token;
    }

}
