package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GetEntitiesFromRoleTypeJson.java 3824 2014-03-20 14:01:16Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/GetEntitiesFromRoleTypeJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.security.AuthorizationService;
import fr.inra.agrosyst.api.services.security.UserRoleEntityDto;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class GetEntitiesFromRoleTypeJson extends AbstractJsonAction {

    private static final long serialVersionUID = -3616533789132105979L;

    protected transient AuthorizationService authorizationService;

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    protected RoleType roleType;
    protected String term;

    protected List<UserRoleEntityDto> entities;

    public void setRoleType(RoleType roleType) {
        this.roleType = roleType;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    @Override
    public String execute() throws Exception {
        entities = authorizationService.searchPossibleEntities(roleType, term);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return entities;
    }
}
