package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsEditJson.java 3150 2014-02-07 08:55:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsEditJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.practiced.CropCycleModelDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.struts2.convention.annotation.Action;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Actions json utilisées par l'action {@link PracticedSystemsEditJson}.
 * 
 * Action supportée:
 * - rechargement au changement 'system de culture' et/ou 'campagne'
 * 
 * @author Eric Chatellier
 */
public class PracticedSystemsEditJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4385936088893971371L;

    protected transient PracticedSystemService practicedSystemService;

    protected String growingSystemId;

    protected String campaigns;

    protected Object jsonData;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    @Action("practiced-systems-crops-tools-json")
    public String execute() {

        Map<String, Object> data = Maps.newHashMap();

        // chargement des toutes les cultures pour les systems de cultures et les années
        Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> modelToSpecies =
                practicedSystemService.getCropCycleModelMap(growingSystemId, campaigns, true);
        Set<CropCycleModelDto> croppingPlanEntryDtos = modelToSpecies.keySet();

        // definition de la liste de culture principale
        Iterable<CropCycleModelDto> modelMain = Iterables.filter(croppingPlanEntryDtos, CroppingPlans.IS_NOT_INTERMEDIATE);
        data.put("practicedSystemMainCropCycleModels", Lists.newArrayList(modelMain)); // force no lazy

        // définition de la liste de culture intermédiaire
        Iterable<CropCycleModelDto> modelIntermediate = Iterables.filter(croppingPlanEntryDtos, CroppingPlans.IS_INTERMEDIATE);
        data.put("practicedSystemIntermediateCropCycleModels", Lists.newArrayList(modelIntermediate)); // force no lazy

        // chargement de la map 'code culture' > liste d'espece
        Map<String, List<CroppingPlanSpeciesDto>> croppingPlanEntryCodesToSpecies = Maps.newHashMap();
        for (Map.Entry<CropCycleModelDto, List<CroppingPlanSpeciesDto>> entry : modelToSpecies.entrySet()) {
            croppingPlanEntryCodesToSpecies.put(entry.getKey().getCroppingPlanEntryCode(), entry.getValue());
        }
        data.put("croppingPlanEntryCodesToSpecies", croppingPlanEntryCodesToSpecies);
        // code du domaine associé au système de culture
        data.put("domainCode", practicedSystemService.getdomainCode(growingSystemId));
        
        jsonData = data;
        return SUCCESS;
    }
    
    public Object getJsonData() {
        return jsonData;
    }
}
