package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadTreatmentTargetsJson.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadTreatmentTargetsJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class LoadTreatmentTargetsJson extends AbstractJsonAction {

    private static final long serialVersionUID = 2286147488098650107L;

    protected transient ReferentialService referentialService;

    protected List<RefBioAgressor> targets;

    protected BioAgressorType category;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setCategory(BioAgressorType category) {
        this.category = category;
    }

    @Override
    public String execute() {
        targets = referentialService.getTreatmentTargets(category);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return targets;
    }

}
