package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadActaTreatmentCodesAndNamesJson.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadActaTreatmentCodesAndNamesJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadActaTreatmentCodesAndNamesJson extends AbstractJsonAction {

    protected Map<String, String> treatmentCodesAndNames;

    protected ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Override
    public String execute() {
        treatmentCodesAndNames = referentialService.getActaTreatementCodesAndNames();
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return treatmentCodesAndNames;
    }
}
