package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsMerge.java 3447 2014-02-24 15:55:20Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsMerge.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Fusion de parcelles.
 *
 * @author Eric Chatellier
 */
public class PlotsMerge extends AbstractAgrosystAction {

    private static final long serialVersionUID = -1618279547328450777L;

    protected transient PlotService plotService;

    /** Plot ids to merge */
    protected List<String> plotTopiaIds;

    /** Duplicated plot instance. */
    protected Plot plot;

    protected String domainTopiaId;

    public String getDomainTopiaId() {
        return domainTopiaId;
    }

    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setPlotTopiaIds(List<String> plotTopiaIds) {
        this.plotTopiaIds = plotTopiaIds;
    }

    public Boolean mergeValidate() {
        Boolean valid = true;
        if (plotTopiaIds != null && plotTopiaIds.size()>1){
            valid = plotService.validMergingPlots(plotTopiaIds);
        } else {
            valid = false;
        }
        return valid;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = { "actionName", "plots-edit-input", "plotTopiaId", "${plot.topiaId}" }),
            @Result(name = ERROR, type = "redirectAction", params = {"namespace", "/domains", "actionName", "domains-edit-input", "domainTopiaId", "${domainTopiaId}"})
    })
    public String execute() throws Exception {
        if(mergeValidate()){
            plot = plotService.mergePlots(plotTopiaIds);
            notificationSupport.plotMerged(plot);
            return SUCCESS;
        } else {
            notificationSupport.plotNotMergeable();
            return ERROR;
        }

    }
    
    public Plot getPlot() {
        return plot;
    }
}
