package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsDuplicate.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsDuplicate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Duplication d'une parcelle.
 *
 * @author Eric Chatellier
 */
public class PlotsDuplicate extends AbstractAgrosystAction {

    private static final long serialVersionUID = -1618279547328450777L;

    protected transient PlotService plotService;

    /** Plot id. */
    protected String plotTopiaId;

    /** Duplicated plot instance. */
    protected Plot plot;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setPlotTopiaId(String plotTopiaId) {
        this.plotTopiaId = plotTopiaId;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = { "actionName", "plots-edit-input", "plotTopiaId", "${plot.topiaId}" }) })
    public String execute() throws Exception {
        plot = plotService.duplicatePlot(plotTopiaId);
        notificationSupport.plotDuplicated(plot);
        return SUCCESS;
    }
    
    public Plot getPlot() {
        return plot;
    }
}
