package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: SearchNetworkJson.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/SearchNetworkJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.LinkedHashMap;
import java.util.Set;

import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 */
public class SearchNetworkJson extends AbstractJsonAction {

    private static final long serialVersionUID = 4654758167246992232L;

    protected transient NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    protected String term;
    protected Set<String> exclusions;
    protected String selfNetworkId;
    protected boolean onNetworkEdition;

    protected LinkedHashMap<String, String> networks;

    public void setTerm(String term) {
        this.term = term;
    }

    public void setExclusions(Set<String> exclusions) {
        this.exclusions = exclusions;
    }

    public void setSelfNetworkId(String selfNetworkId) {
        this.selfNetworkId = selfNetworkId;
    }

    public void setOnNetworkEdition(boolean onNetworkEdition) {
        this.onNetworkEdition = onNetworkEdition;
    }

    @Override
    public String execute() {
        //TODO david, 07/08/2013 add a parameter for the number of expecting result
        networks = networkService.searchNameFilteredActiveNetworks(term, 10, exclusions, selfNetworkId, onNetworkEdition);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return networks;
    }

}
