package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ManagementModesListJson.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/ManagementModesListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeFilter;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Management mode list json action.
 * 
 * @author Eric Chatellier
 */
public class ManagementModesListJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5032928580196001618L;

    protected transient ManagementModeService managementModeService;

    protected String filter;

    protected ResultList<ManagementModeDto> managementModeDtos;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        ManagementModeFilter managementModeFilter = getGson().fromJson(filter, ManagementModeFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        managementModeFilter.setNavigationContext(navigationContext);
        managementModeDtos = managementModeService.getFilteredManagementModeDtos(managementModeFilter);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return managementModeDtos;
    }

}
