package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ManagementModesList.java 3150 2014-02-07 08:55:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/ManagementModesList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeFilter;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Management modes list action.
 * 
 * @author Eric Chatellier
 */
public class ManagementModesList extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5032928580196001618L;

    protected transient ManagementModeService managementModeService;

    protected ResultList<ManagementModeDto> managementModeDtos;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    @Override
    public String execute() throws Exception {
        NavigationContext navigationContext = getNavigationContext();
        ManagementModeFilter filter = new ManagementModeFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(getConfig().getListResultsPerPage());

        managementModeDtos = managementModeService.getFilteredManagementModeDtos(filter);

        return SUCCESS;
    }

    public ResultList<ManagementModeDto> getManagementModeDtos() {
        return managementModeDtos;
    }

    public Map<ManagementModeCategory, String> getManagementModeCategories() {
        return getEnumAsMap(ManagementModeCategory.values());
    }
}
