package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DecisionRulesListJson.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/DecisionRulesListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.managementmode.DecisionRuleFilter;
import fr.inra.agrosyst.api.services.managementmode.DecisionRulesDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Decision rules list json action.
 * 
 * @author Eric Chatellier
 */
public class DecisionRulesListJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -7454396591234192201L;

    protected transient ManagementModeService managementModeService;

    protected String filter;

    protected ResultList<DecisionRulesDto> decisionRules;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        DecisionRuleFilter decisionRulefilter = getGson().fromJson(filter, DecisionRuleFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        decisionRulefilter.setNavigationContext(navigationContext);
        decisionRules = managementModeService.getFilteredDecisionRules(decisionRulefilter);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return decisionRules;
    }
}
