package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingSystemsListJson.java 3546 2014-02-27 22:04:06Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/GrowingSystemsListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class GrowingSystemsListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -5974287104680221588L;

    protected transient GrowingSystemService growingSystemService;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }


    protected boolean fromNavigationContextChoose = false;
    protected String filter;
    protected Set<Integer> selectedCampaigns = Sets.newHashSet();
    protected Set<String> selectedNetworks = Sets.newHashSet();
    protected Set<String> selectedDomains = Sets.newHashSet();
    protected Set<String> selectedGrowingPlans = Sets.newHashSet();

    protected ResultList<GrowingSystemDto> growingSystems;

    public void setFromNavigationContextChoose(boolean fromNavigationContextChoose) {
        this.fromNavigationContextChoose = fromNavigationContextChoose;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    public void setSelectedNetworks(Set<String> selectedNetworks) {
        this.selectedNetworks = selectedNetworks;
    }

    public void setSelectedDomains(Set<String> selectedDomains) {
        this.selectedDomains = selectedDomains;
    }

    public void setSelectedGrowingPlans(Set<String> selectedGrowingPlans) {
        this.selectedGrowingPlans = selectedGrowingPlans;
    }

    @Override
    public String execute() {
        GrowingSystemFilter growingSystemFilter = getGson().fromJson(filter, GrowingSystemFilter.class);
        NavigationContext navigationContext;
        if (fromNavigationContextChoose) {
            navigationContext = new NavigationContext();
            navigationContext.setCampaigns(selectedCampaigns);
            navigationContext.setNetworks(selectedNetworks);
            navigationContext.setDomains(selectedDomains);
            navigationContext.setGrowingPlans(selectedGrowingPlans);
        } else {
            navigationContext = getNavigationContext();
        }
        growingSystemFilter.setNavigationContext(navigationContext);
        growingSystems = growingSystemService.getFilteredGrowingSystemsDto(growingSystemFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return growingSystems;
    }

}
