package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingSystemsList.java 3452 2014-02-24 23:58:35Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/GrowingSystemsList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class GrowingSystemsList extends AbstractAgrosystAction {

    private static final long serialVersionUID = -8763014594787954150L;

    protected transient GrowingSystemService growingSystemService;

    protected GrowingSystemFilter growingSystemFilter;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    /**
     * Result serialized in json.
     */
    protected ResultList<GrowingSystemDto> growingSystems;

    @Override
    public String execute() throws Exception {

        NavigationContext navigationContext = getNavigationContext();
        growingSystemFilter = new GrowingSystemFilter();
        growingSystemFilter.setNavigationContext(navigationContext);
        growingSystemFilter.setPageSize(getConfig().getListResultsPerPage());
        growingSystemFilter.setActive(Boolean.TRUE);

        growingSystems = growingSystemService.getFilteredGrowingSystemsDto(growingSystemFilter);
        return SUCCESS;
    }

    public String getGrowingSystemsJson() {
        String result = getGson().toJson(growingSystems);
        return result;
    }

    public Map<Sector, String> getSectors() {
        return getEnumAsMap(Sector.values());
    }

    public GrowingSystemFilter getGrowingSystemFilter() {
        return growingSystemFilter;
    }

}
