package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansImport.java 3929 2014-03-31 13:00:58Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansImport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Import growing plan XLS file.
 * 
 * @author Eric Chatellier
 */
@Results({
        @Result(type = "redirectAction", name = "input", params = {"actionName", "growing-plans-list", "importFileError", "true"})
})
public class GrowingPlansImport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(GrowingPlansImport.class);

    private static final long serialVersionUID = 2031204987636332755L;

    protected File file;

    public void setFile(File file) {
        this.file = file;
    }

    protected transient GrowingPlanService growingPlanService;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    @Override
    @Action(results = {
            @Result(type = "redirectAction", params = {"actionName", "growing-plans-list"})})
    public String execute() throws Exception {
        InputStream stream = null;
        try {
            stream = new FileInputStream(file);
            growingPlanService.importGrowingPlanForXlsStream(stream);
            notificationSupport.importSuccess();
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import xls file", ex);
            }
            notificationSupport.importError(ex.getMessage());
        } finally {
            IOUtils.closeQuietly(stream);
        }
        return SUCCESS;
    }
}
